#!/usr/bin/ruby

# Reboots nodes from cli arguments
# Reads args into an array and outputs to
# a file which XCAT reads.
# If node is not on allowed list nothing happens
# username and node are logged to a file
# Created for Thaniel's peeps

userNodes = ARGV # save the cli args into an array
person = ENV['USER'] # tagging the user for accounting/blame
# allowed nodes
servList = ['node1','node2','node3','node4','node5','node6','node7']
#container for requested rebootable nodes
userList = Array.new

# Takes args from CLI and compares to
# the allowed server list. If node is not
# in list, reboot is denied
# if it is in the list, node names
# are written to a file along with username
# and xcat will do the reboot.
userNodes.each do | node |
  if servList.include?(node)
    userList.push(node)
  else
    puts("#{node} is not allowed.  try again")
  end
end

# Tag user for tracking and accounting
# need a way to assign blame for wrongly rebooted
# nodes
puts("user:#{person}")

# The nodes that need rebooting.
userList.each do | node2|
  puts("node:#{node2}")
end

# Write to file for xcat parsing
File.open('/rebootNodes','w') do |f2|
  f2.puts("#{person}")
  f2.puts(userList.each do | node2 | end)
end